//
//  MainViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 14.02.23.
//

import UIKit

// https://www.youtube.com/watch?v=aU_kTzMZHQ8&t=248s
class MainViewController: UIViewController { // , UIViewControllerTransitioningDelegate
    
    @IBOutlet weak var collectionView: UICollectionView!
    
    
    let appDelegate = UIApplication.shared.delegate as! AppDelegate
    let userLicenseAgreement  = """
        AGB und Datenschutzerklärung
        """
    
    override func viewDidLoad() {
        
        showBackButtonPublic = false
        
        
        // Custom color
        let greyColor = UIColor(red: 108/255, green: 108/255, blue: 108/255, alpha: 1)

        
        navigationController?.navigationBar.titleTextAttributes = [NSAttributedString.Key.font: UIFont(descriptor: UIFontDescriptor(name: "Avenir-Heavy", size: 17), size: 17), NSAttributedString.Key.foregroundColor : greyColor]
        

        let headerText = "H" // "HCS — H"
        let headerText_human = "uman "
        let headerText_C = "C"
        let headerText_centered = "entered "
        let headerText_S = "S"
        let headerText_sudies = "tudies"

        let attrs_medium: [NSAttributedString.Key: Any] = [
            .font: UIFont(name: "Avenir-Medium", size: 17) ?? UIFont.boldSystemFont(ofSize: 17),
            .foregroundColor: Colors.carmine // greyColor
        ]
        let attrs_heavy: [NSAttributedString.Key: Any] = [
            .font: UIFont(name: "Avenir-Heavy", size: 17) ?? UIFont.boldSystemFont(ofSize: 17),
            .foregroundColor: Colors.carmine // greyColor
        ]

        let attributedString = NSMutableAttributedString(string: headerText, attributes: attrs_heavy)
        
        let headerString_HCS_Human = NSAttributedString(string: headerText_human, attributes: attrs_medium)
        let headerString_C = NSAttributedString(string: headerText_C, attributes: attrs_heavy)
        let headerString_centered = NSAttributedString(string: headerText_centered, attributes: attrs_medium)
        let headerString_S = NSAttributedString(string: headerText_S, attributes: attrs_heavy)
        let headerString_studies = NSAttributedString(string: headerText_sudies, attributes: attrs_medium)
        
        attributedString.append(headerString_HCS_Human)
        attributedString.append(headerString_C)
        attributedString.append(headerString_centered)
        attributedString.append(headerString_S)
        attributedString.append(headerString_studies)
        

        let label = UILabel()
        label.attributedText = attributedString
        label.sizeToFit()

        navigationItem.titleView = label
        

        


        dataProtectionCalledFromHomeVCPublic = true
        
        super.viewDidLoad()
        
        collectionView.dataSource = self
        
        collectionView.delegate = self
        
        collectionView.collectionViewLayout = UICollectionViewFlowLayout()
        
    }
    
    override func viewDidAppear(_ animated: Bool) {
        
        let defaults = UserDefaults.standard
        //check license agreement
        if (defaults.object(forKey: "showLicenseAgreement_v0") != nil)
        {
            showLicenseAgreementPublic = defaults.bool(forKey: "showLicenseAgreement_v0")
            if(showLicenseAgreementPublic) {
                let storyBoard: UIStoryboard = UIStoryboard(name: "Main", bundle: nil)
                let vc = storyBoard.instantiateViewController(withIdentifier: "LicenseAgreementVC") as! LicenseAgreementViewController
                self.view.window?.rootViewController = vc
                self.view.window?.makeKeyAndVisible()
            }
        } else {
            let storyBoard: UIStoryboard = UIStoryboard(name: "Main", bundle: nil)
            let vc = storyBoard.instantiateViewController(withIdentifier: "LicenseAgreementVC") as! LicenseAgreementViewController
            self.view.window?.rootViewController = vc
            self.view.window?.makeKeyAndVisible()
        }
    }
    
    func displayLicenAgreement(message:String){
            
            //create alert
            let alert = UIAlertController(title: "License Agreement", message: message, preferredStyle: .alert)
            
            //create Decline button
            let declineAction = UIAlertAction(title: "Decline" , style: .destructive){ (action) -> Void in
                //DECLINE LOGIC GOES HERE
                
            }
            
            //create Accept button
            let acceptAction = UIAlertAction(title: "Accept", style: .default) { (action) -> Void in
                //ACCEPT LOGIC GOES HERE
            }
            
            //add task to tableview buttons
            alert.addAction(declineAction)
            alert.addAction(acceptAction)
            
            
            self.present(alert, animated: true, completion: nil)
        }
    
    func navTitleWithImageAndText(titleText: String, imageName: String) -> UIView {

        // Creates a new UIView
        let titleView = UIView()

        // Creates a new text label
        let label = UILabel()
        label.text = titleText
        label.sizeToFit()
        label.center = titleView.center
        label.textAlignment = NSTextAlignment.center

        // Creates the image view
        let image = UIImageView()
        image.image = UIImage(named: imageName)

        // Maintains the image's aspect ratio:
        let imageAspect = image.image!.size.width / image.image!.size.height

        // Sets the image frame so that it's immediately before the text:
        let imageX = label.frame.origin.x - label.frame.size.height * imageAspect
        let imageY = label.frame.origin.y

        let imageWidth = label.frame.size.height * imageAspect
        let imageHeight = label.frame.size.height

        image.frame = CGRect(x: imageX, y: imageY, width: imageWidth, height: imageHeight)

        image.contentMode = UIView.ContentMode.scaleAspectFit

        // Adds both the label and image view to the titleView
        titleView.addSubview(label)
        titleView.addSubview(image)

        // Sets the titleView frame to fit within the UINavigation Title
        titleView.sizeToFit()

        return titleView

    }
    
}


extension MainViewController: UICollectionViewDataSource {
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return studies.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell =
            collectionView
            .dequeueReusableCell(withReuseIdentifier: "StudyCollectionViewCell", for: indexPath) as!
            StudyCollectionViewCell
        
        cell.setup(with: studies[indexPath.row])
        return cell
    }
}

extension MainViewController: UICollectionViewDelegateFlowLayout {
    func collectionView (_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        
        //let height = view.frame.size.height
        let width = view.frame.size.width
        
        return CGSize(width: width * 0.4, height: width * 0.4 * 1.33)
        //return CGSize(width: 180, height: 240) // width: 163, height: 180 // 240
    }
}

extension MainViewController: UICollectionViewDelegate {
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        print(studies[indexPath.row].title)
        
        if(studies[indexPath.row].title == "Light Banking (Online Banking)") { // Online Banking

            let vc = self.storyboard?.instantiateViewController(withIdentifier: "TEST55")
            
            let layout = UICollectionViewFlowLayout()
            self.view.window?.rootViewController = AuthenticationScreenViewController(collectionViewLayout: layout)
            
            
            
            self.view.window?.rootViewController = vc
            self.view.window?.makeKeyAndVisible()
        } else if (studies[indexPath.row].title == "Smartphone Nutzung") {
            let nc = self.storyboard?.instantiateViewController(withIdentifier: "SurveySmartphoneUsageNC") as! UINavigationController
            
            nc.modalPresentationStyle = .fullScreen
            nc.modalTransitionStyle = .crossDissolve
            
            present(nc, animated: true)
        } else if (studies[indexPath.row].title == "Smartphone vs Computer") {
            let nc = self.storyboard?.instantiateViewController(withIdentifier: "SurveyHealthAppsNC") as! UINavigationController
            
            nc.modalPresentationStyle = .fullScreen
            nc.modalTransitionStyle = .crossDissolve
            
            present(nc, animated: true)
        } else {
           
            

                    
            // Fallback...
            if #available(iOS 15.0, *) {
                let storyboard = UIStoryboard(name: "Main", bundle: nil)
                        let viewController = storyboard.instantiateViewController(withIdentifier: "NotAvailableStudiesNC")
                
                if let presentationController = viewController.presentationController as? UISheetPresentationController {

                    
                    presentationController.detents = [.medium()] /// change to [.medium(), .large()] for a half *and* full screen sheet
                }
                
                self.present(viewController, animated: true)
                
            } else {
                let storyboard = UIStoryboard(name: "Main", bundle: nil)
                        let viewController = storyboard.instantiateViewController(withIdentifier: "NotAvailableStudiesVC")
                viewController.modalPresentationStyle = .custom
                viewController.transitioningDelegate = self
                self.present(viewController, animated: true, completion: nil)
            }
                                
            
        }
    }
}

// MARK: - UIViewControllerTransitioningDelegate
extension MainViewController: UIViewControllerTransitioningDelegate {
    
    func presentationController(forPresented presented: UIViewController, presenting: UIViewController?, source: UIViewController) -> UIPresentationController? {
        PresentationController(presentedViewController: presented, presenting: presenting)
    }
}
